#ifndef KEYBOARD_H_
#define KEYBOARD_H_

//Carlos' code
#define LEFT_ARROW 0x6B
#define RIGHT_ARROW 0x74
//end of Carlos' code

KB_CODE_TYPE decode_mode;
int intitialize_keyboard(){
  // Initialize the keyboard
  printf("Please wait three seconds to initialize keyboard\n");
  clear_FIFO();
  switch (get_mode()) {
  case PS2_KEYBOARD:
    break;
  case PS2_MOUSE:
    printf("Error: Mouse detected on PS/2 port\n");
    return -1;
  default:
    printf("Error: Unrecognized or no device on PS/2 port\n");
    return -2;
  }  
}

/*
alt_u8 getKey(){
    alt_u8 key = 0;
    int status = read_make_code(&decode_mode, &key);
    if (status == PS2_SUCCESS) {
      // print out the result
      switch ( decode_mode ) {
        case KB_ASCII_MAKE_CODE :
            printf("%x", key );
        break ;
      case KB_LONG_BINARY_MAKE_CODE :
            printf("%x", key);
        return key;
       case KB_BINARY_MAKE_CODE :
        //  printf("%x", key);   
         return key;
        case KB_BREAK_CODE :
        // do nothing
        default :
         break ;
      } // end switch on decode mode
    }
}*/

//Carlos' code
alt_u8 getKey(){
    alt_u8 key = 0;
    int status = read_make_code(&decode_mode, &key);

    //Carlos'
    unsigned int color1,color2,R1,R2,G1,G2,B1,B2;
    unsigned int le = 0;
    unsigned int ri = 0;
    cam = IORD_VGA_DATA(VGA_BASE,1);

    if(cam==1){
        color1 = IORD_VGA_DATA(VGA_BASE,2);
        color2 = IORD_VGA_DATA(VGA_BASE,3);

        R1 = (0x000003FF & color1);
        G1 = (0x000003FF & (color1>>10));
        B1 = (0x000003FF & (color1>>20));

        R2 = (0x000003FF & color2);
        G2 = (0x000003FF & (color2>>10));
        B2 = (0x000003FF & (color2>>20));

        if (R1<0x3FF && R1>0x270 && G1<0x270 && B1<0x3FF)
            ri = 1;

        if (R2<0x3FF && R2>0x270 && G2<0x270 && B2<0x3FF)
            le = 1; 
    }

    if (status == PS2_SUCCESS && le==0 && ri==0) {
      // print out the result
      switch ( decode_mode ) {
        case KB_ASCII_MAKE_CODE :
            printf("%x", key );
        break ;
      case KB_LONG_BINARY_MAKE_CODE :
            printf("%x", key);
        return key;
       case KB_BINARY_MAKE_CODE :
        //  printf("%x", key);   
         return key;
        case KB_BREAK_CODE :
        // do nothing
        default :
         break ;
      } // end switch on decode mode
    }else{
        if(le==1)
            return LEFT_ARROW;
        else if (ri==1)
            return RIGHT_ARROW;
    }
}
//end of Carlos' code


#endif /*TERRAIN_H_*/